<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>HIMS AI | Agentic Care Console</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;500;600;700;800&family=Space+Grotesk:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
  <div class="bg-orb orb-a" aria-hidden="true"></div>
  <div class="bg-orb orb-b" aria-hidden="true"></div>
  <div class="bg-orb orb-c" aria-hidden="true"></div>
  <div class="noise-layer" aria-hidden="true"></div>

  <div class="app-shell">
    <header class="topbar">
      <div class="brand">
        <span class="pulse-dot" aria-hidden="true"></span>
        <div>
          <h1>HIMS AI</h1>
          <p>Agentic Care Console</p>
        </div>
      </div>

      <div class="topbar-actions">
        <button id="themeMotionToggle" type="button" class="ghost-btn">Reduce Motion</button>
        <button id="logoutBtn" type="button" class="ghost-btn hidden">Logout</button>
      </div>
    </header>

    <main>
      <section id="authView" class="view">
        <div class="auth-grid">
          <article class="glass-card hero-card reveal">
            <span class="eyebrow">Healthcare Operations, Reimagined</span>
            <h2>Real-time hospital workflow with local auth and AI streaming</h2>
            <p>
              Built for rapid demo cycles: patient onboarding, doctor queue management, admin insights,
              appointment automation, and AI output rendered live word by word.
            </p>
            <div class="feature-pills">
              <span>LocalStorage Auth</span>
              <span>Role-based UI</span>
              <span>Live AI Stream</span>
              <span>Automation Hooks</span>
            </div>
          </article>

          <article class="glass-card auth-card reveal delay-1">
            <div class="tab-switch">
              <button id="loginTab" class="tab-btn active" type="button">Login</button>
              <button id="registerTab" class="tab-btn" type="button">Register</button>
            </div>

            <form id="loginForm" class="auth-form" autocomplete="on">
              <label>Email</label>
              <input name="email" type="email" placeholder="you@hospital.local" required>
              <label>Password</label>
              <input name="password" type="password" placeholder="••••••••" required>
              <button type="submit" class="solid-btn">Sign In</button>
            </form>

            <form id="registerForm" class="auth-form hidden" autocomplete="on">
              <label>Full Name</label>
              <input name="name" type="text" placeholder="Aarav Khanna" minlength="3" required>
              <label>Email</label>
              <input name="email" type="email" placeholder="new@hospital.local" required>
              <label>Password</label>
              <input name="password" type="password" minlength="6" placeholder="At least 6 characters" required>
              <label>Role</label>
              <select name="role" required>
                <option value="patient">Patient</option>
                <option value="doctor">Doctor</option>
                <option value="admin">Admin</option>
              </select>
              <button type="submit" class="solid-btn">Create Account</button>
            </form>

            <div id="authHint" class="auth-hint">
              Demo accounts: patient@hims.local / 123456, doctor@hims.local / 123456, admin@hims.local / 123456
            </div>
          </article>
        </div>
      </section>

      <section id="appView" class="view hidden">
        <div class="dashboard-grid">
          <aside class="glass-card sidebar reveal">
            <div class="user-meta">
              <p class="label">Signed In As</p>
              <h3 id="userName">Name</h3>
              <p id="userRole">Role</p>
              <p id="userEmail">Email</p>
            </div>

            <div class="nav-stack">
              <button class="nav-btn active" type="button" data-panel="workspacePanel">Workspace</button>
              <button class="nav-btn" type="button" data-panel="assistantPanel">AI Studio</button>
              <button class="nav-btn" type="button" data-panel="analyticsPanel">Insights</button>
            </div>

            <div class="status-card">
              <span>Automation Mode</span>
              <strong>Active</strong>
              <p>Completion event triggers follow-up summary and notification planning.</p>
            </div>
          </aside>

          <section class="main-stack">
            <article id="workspacePanel" class="glass-card panel reveal"></article>

            <article id="assistantPanel" class="glass-card panel hidden">
              <div class="panel-head">
                <h3>AI Assistant Stream</h3>
                <span class="chip">Word-by-word output</span>
              </div>

              <div id="chatStream" class="chat-stream" aria-live="polite"></div>

              <form id="chatForm" class="chat-form">
                <textarea id="chatInput" placeholder="Ask for diagnosis outline, discharge notes, or patient explanation..." required></textarea>
                <button id="chatSubmit" class="solid-btn" type="submit">Generate</button>
              </form>
            </article>

            <article id="analyticsPanel" class="glass-card panel hidden"></article>
          </section>
        </div>
      </section>
    </main>
  </div>

  <template id="appointmentCardTemplate">
    <article class="appointment-card">
      <div class="card-head">
        <h4 class="appt-title"></h4>
        <span class="badge appt-status"></span>
      </div>
      <p class="appt-meta"></p>
      <p class="appt-notes"></p>
      <div class="appt-actions"></div>
    </article>
  </template>

  <script src="assets/js/app.js"></script>
</body>
</html>
