# HIMS AI LocalStorage Demo

Modern hospital workflow demo with:

- LocalStorage auth (patient, doctor, admin)
- Appointment booking + slot conflict prevention
- Doctor queue with completion automation
- Admin metrics and analytics
- AI proxy in PHP with SSE word-by-word streaming

No Firebase or external DB is used in this version.

## Stack

- Frontend: `index.php`, `assets/css/style.css`, `assets/js/app.js`
- Backend: `api/chat.php` (Groq/OpenAI-compatible API call)

## Quick Start (Namecheap / any PHP hosting)

1. Upload project files.
2. Configure a server environment variable:
   - `GROQ_API_KEY=your_real_key`
3. Optional model override:
   - `GROQ_MODEL=llama-3.3-70b-versatile`
4. Open `index.php`.

If your hosting cannot set environment variables easily, copy:

- `api/config.local.example.php` -> `api/config.local.php`

Then put your key inside `config.local.php` (private server file only).

## Demo Accounts

- `patient@hims.local` / `123456`
- `doctor@hims.local` / `123456`
- `admin@hims.local` / `123456`

## Notes

- All auth and appointment data are stored in browser LocalStorage.
- AI key is never exposed in frontend code.
- `api/chat.php` streams model output token-by-token as SSE packets.
