# 🚀 Flutter AI Assistant

A modern, AI-powered chatbot specialized in Flutter development, using Llama models via Groq API.

## ✨ Features

- 🤖 **Powered by Llama AI**: Uses latest Llama 3.3 70B model via Groq
- 🎨 **Modern UI**: Glassmorphic design with smooth animations
- 📱 **Fully Responsive**: Works perfectly on desktop, tablet, and mobile
- ⚡ **Fast Responses**: Optimized for quick AI inference
- 🎯 **Flutter Specialized**: Trained to provide accurate Flutter/Dart advice
- 🔒 **Secure**: API key protected, CORS enabled
- 💯 **Free**: Uses Groq's free tier (no credit card required)

## 🛠️ Technologies Used

- **Frontend**: HTML5, CSS3 (Vanilla), JavaScript (ES6+)
- **Backend**: PHP 7.4+
- **AI**: Llama 3.3 70B via Groq API
- **Hosting**: Compatible with Namecheap shared hosting

## 📦 Project Structure

```
g/
├── index.html          # Main HTML file
├── style.css           # Modern CSS design system
├── script.js           # JavaScript for chat functionality
├── config.php          # Configuration (API keys, settings)
├── .htaccess          # Apache configuration
├── api/
│   └── chat.php       # API endpoint for chat
└── README.md          # This file
```

## 🚀 Setup Instructions

### Prerequisites

- PHP 7.4 or higher
- cURL extension enabled
- Apache server (with mod_rewrite)
- Groq API key (free at console.groq.com)

### Installation Steps

1. **Upload Files to Namecheap**
   - Upload all files to your public_html directory (or subdirectory)
   - Ensure the folder structure is maintained

2. **Verify PHP Version**
   - Check that your hosting supports PHP 7.4+
   - Enable cURL extension if not already enabled

3. **Set Permissions**
   ```bash
   chmod 644 config.php
   chmod 644 api/chat.php
   chmod 644 .htaccess
   ```

4. **Test the Installation**
   - Visit your domain: `https://yourdomain.com`
   - Try asking a Flutter question
   - Check that responses are working

### Configuration

Your API key is already configured in `config.php`:
```php
define('GROQ_API_KEY', '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');
```

**Security Note**: The `.htaccess` file prevents direct access to `config.php` from the web.

## 🎨 Customization

### Change Colors
Edit `style.css` and modify the CSS variables:
```css
:root {
  --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  --accent-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
  /* ... more variables */
}
```

### Modify AI Behavior
Edit `config.php` to adjust:
- `AI_MODEL`: Change the Llama model
- `TEMPERATURE`: Lower (0.1-0.3) for accuracy, higher (0.7-1.0) for creativity
- `MAX_TOKENS`: Maximum response length
- `SYSTEM_PROMPT`: Customize the AI's personality and expertise

### Add More Suggestion Chips
Edit `index.html` and add more suggestion chips:
```html
<div class="suggestion-chip" onclick="sendSuggestion('Your question here')">
    🔥 Your Topic
</div>
```

## 🔧 Troubleshooting

### Chat not working
1. Check browser console for errors (F12)
2. Verify `api/chat.php` is accessible
3. Ensure PHP cURL extension is enabled
4. Check file permissions

### API Errors
1. Verify Groq API key is correct
2. Check Groq API status at status.groq.com
3. Review error logs in your hosting control panel

### Styling Issues
1. Clear browser cache (Ctrl+F5)
2. Check that `style.css` is loading
3. Verify CSS file path is correct

## 📱 Browser Support

- ✅ Chrome/Edge (latest)
- ✅ Firefox (latest)
- ✅ Safari (latest)
- ✅ Mobile browsers (iOS Safari, Chrome Mobile)

## 🔒 Security Best Practices

1. **API Key Protection**: Never expose your API key in frontend code
2. **CORS**: Update `ALLOWED_ORIGINS` in `config.php` for production
3. **Rate Limiting**: Consider adding rate limiting for production use
4. **HTTPS**: Always use HTTPS in production
5. **Error Logging**: Monitor error logs regularly

## 📊 Performance Tips

1. Enable GZIP compression (already in `.htaccess`)
2. Use browser caching (already configured)
3. Consider adding a CDN for static assets
4. Monitor Groq API usage to stay within free tier limits

## 🆘 Support

For issues or questions:
1. Check the troubleshooting section above
2. Review Groq API documentation: docs.groq.com
3. Check browser console for JavaScript errors
4. Verify server error logs

## 📝 License

This project is free to use and modify for personal and commercial purposes.

## 🙏 Credits

- **AI Model**: Llama by Meta, served via Groq
- **Design**: Custom modern UI with glassmorphism
- **Icons**: Emoji (cross-platform compatible)

---

**Made with ❤️ for Flutter developers**
