-- =====================================================
-- BGNU Exam Progress Tracking Table
-- Run this in phpMyAdmin to add the new table
-- =====================================================

-- Create exam_progress table for real-time tracking
CREATE TABLE IF NOT EXISTS exam_progress (
    id INT AUTO_INCREMENT PRIMARY KEY,
    session_token VARCHAR(64) NOT NULL,
    student_email VARCHAR(255) NOT NULL,
    student_name VARCHAR(255) NOT NULL,
    exam_code VARCHAR(50) NOT NULL,
    answers_json TEXT,
    time_remaining INT DEFAULT 0,
    current_question INT DEFAULT 0,
    total_questions INT DEFAULT 0,
    answered_count INT DEFAULT 0,
    last_sync DATETIME,
    created_at DATETIME NOT NULL,
    
    UNIQUE KEY unique_session (session_token),
    INDEX idx_exam_code (exam_code),
    INDEX idx_student_email (student_email),
    INDEX idx_last_sync (last_sync)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Verify table was created
SELECT 'exam_progress table created successfully!' as Result;
