<?php
// Browser verification temporarily disabled for Windows compatibility
// The anti-cheat JavaScript will handle security
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$isDinoBrowser = true; // Allow all browsers for now - anti-cheat JS handles security

// Temporarily disabled to avoid Windows crash
// $isDinoBrowser = strpos($userAgent, 'DINO-ExamBrowser') !== false || 
//                  strpos($userAgent, 'BGNU-ExamBrowser') !== false;

if (!$isDinoBrowser) {
    // Block access from other browsers
    http_response_code(403);
    ?>
<!DOCTYPE html>
<html>

<head>
    <title>Access Denied</title>
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: #0a0a0f;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
            text-align: center;
        }

        .container {
            max-width: 500px;
            padding: 40px;
        }

        h1 {
            color: #ef4444;
            font-size: 2rem;
        }

        p {
            color: #a0a0b0;
            margin: 20px 0;
        }

        a {
            display: inline-block;
            margin-top: 20px;
            padding: 12px 24px;
            background: #6366f1;
            color: white;
            text-decoration: none;
            border-radius: 8px;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>🎓 Access Denied</h1>
        <p>This exam can only be accessed through <strong>BGNU Exam Browser</strong>.</p>
        <p>Please download and install the browser to continue.</p>
        <a href="https://bilalcode.site/download-bgnu-browser">Download BGNU Browser</a>
    </div>
</body>

</html>
<?php
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BGNU Exam Portal</title>
    <link rel="stylesheet" href="exam.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
</head>

<body>
    <div class="exam-container">
        <!-- Header -->
        <header class="exam-header">
            <div class="logo">
                <span class="logo-icon">🎓</span>
                <span class="logo-text">BGNU Exam</span>
            </div>
            <div class="header-info">
                <div class="timer" id="timer">
                    <span class="timer-icon">⏱️</span>
                    <span id="time-display">--:--</span>
                </div>
                <div class="connection-status" id="connection-status">
                    <span class="status-dot offline"></span>
                    <span>Offline</span>
                </div>
            </div>
        </header>

        <!-- Pre-Exam Screen -->
        <div class="screen" id="pre-exam-screen">
            <div class="welcome-card">
                <div class="welcome-icon">📝</div>
                <h1>Welcome to BGNU Exam</h1>
                <p>Click the button below to load your exam questions. Once loaded, you can answer questions even
                    without internet.</p>

                <div class="exam-info" id="exam-info" style="display: none;">
                    <div class="info-item">
                        <span class="info-label">Exam:</span>
                        <span class="info-value" id="exam-title">--</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Duration:</span>
                        <span class="info-value" id="exam-duration">--</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Questions:</span>
                        <span class="info-value" id="exam-questions">--</span>
                    </div>
                </div>

                <div class="input-group">
                    <label for="roll-no">Roll Number</label>
                    <input type="text" id="roll-no" placeholder="Enter your roll number">
                </div>
                <div class="input-group">
                    <label for="student-email">Your Email</label>
                    <input type="email" id="student-email" placeholder="your.email@bgnu.edu">
                </div>
                <div class="input-group">
                    <label for="student-name">Your Name</label>
                    <input type="text" id="student-name" placeholder="Full Name">
                </div>

                <button class="btn-primary" id="load-data-btn">
                    <span class="btn-icon">📥</span>
                    Load Exam Data
                </button>
                <p class="helper-text" id="load-status"></p>
            </div>
        </div>

        <!-- Exam Screen -->
        <div class="screen hidden" id="exam-screen">
            <!-- Progress Bar -->
            <div class="progress-container">
                <div class="progress-bar" id="progress-bar"></div>
                <span class="progress-text" id="progress-text">0 / 0</span>
            </div>

            <!-- Question Card -->
            <div class="question-card">
                <div class="question-number" id="question-number">Question 1</div>
                <div class="question-prompt" id="question-prompt">
                    Loading question...
                </div>

                <div class="options-container" id="options-container">
                    <!-- Options will be rendered here -->
                </div>
            </div>

            <!-- Navigation -->
            <div class="nav-buttons">
                <button class="btn-nav" id="prev-btn" disabled>
                    ← Previous
                </button>
                <div class="question-dots" id="question-dots">
                    <!-- Dots will be rendered here -->
                </div>
                <button class="btn-nav" id="next-btn">
                    Next →
                </button>
            </div>

            <!-- Submit Button -->
            <button class="btn-submit hidden" id="submit-btn">
                <span class="btn-icon">✅</span>
                Submit Exam
            </button>
        </div>

        <!-- Result Screen -->
        <div class="screen hidden" id="result-screen">
            <div class="result-card">
                <div class="result-icon" id="result-icon">🎉</div>
                <h1 id="result-title">Exam Submitted!</h1>
                <p id="result-message">Your answers have been saved successfully.</p>
                <div class="result-stats" id="result-stats">
                    <!-- Stats will be shown here -->
                </div>
            </div>
        </div>
    </div>

    <script src="exam.js"></script>
</body>

</html>