<?php
header('Content-Type: application/json');

// Browser verification function
// Note: Browser User-Agent check is disabled as it causes Windows WebView crashes
// Security is now handled by JavaScript anti-cheat on the exam page
function isBGNUBrowser() {
    // Always return true - browser verification disabled for compatibility
    // The exam page JavaScript handles security instead
    return true;
    
    // Original check (disabled):
    // $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    // return strpos($userAgent, 'BGNU-ExamBrowser') !== false;
}

// Verify browser - always passes now
if (!isBGNUBrowser()) {
    http_response_code(403);
    echo json_encode([
        'error' => 'Access Denied',
        'message' => 'This exam system can only be accessed through BGNU Exam Browser.',
        'download_url' => 'https://bilalcode.site/download-bgnu-browser'
    ]);
    exit;
}

// Extract session token from User-Agent if present
function extractSessionToken() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    if (preg_match('/SessionToken:([a-zA-Z0-9]+)/', $userAgent, $matches)) {
        return $matches[1];
    }
    return null;
}
?>
