<?php
/**
 * Terminate Exam API
 * Called when cheating is detected
 */

require_once '../config/database.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die(json_encode(['error' => 'Method not allowed']));
}

$data = json_decode(file_get_contents('php://input'), true);

$session_token = $data['session_token'] ?? '';
$reason = $data['reason'] ?? 'unknown';
$message = $data['message'] ?? 'Exam terminated due to security violation';

if (empty($session_token)) {
    http_response_code(400);
    die(json_encode(['error' => 'Session token required']));
}

try {
    // Update session status to terminated
    $stmt = $pdo->prepare("
        UPDATE active_sessions 
        SET session_status = 'terminated',
            termination_reason = ?,
            submitted_at = NOW()
        WHERE session_token = ?
    ");
    $stmt->execute([$reason, $session_token]);

    // Update exam_progress table
    $stmt = $pdo->prepare("
        UPDATE exam_progress 
        SET status = 'terminated'
        WHERE session_token = ?
    ");
    $stmt->execute([$session_token]);

    // Record the termination as a result with 0 score
    $stmt = $pdo->prepare("
        SELECT learner_id, assessment_id FROM active_sessions WHERE session_token = ?
    ");
    $stmt->execute([$session_token]);
    $session = $stmt->fetch();

    if ($session) {
        $stmt = $pdo->prepare("
            INSERT INTO assessment_results (
                session_token, learner_id, assessment_id, 
                total_score, maximum_score, pass_status, was_terminated
            ) VALUES (?, ?, ?, 0, 0, 0, 1)
            ON DUPLICATE KEY UPDATE was_terminated = 1, total_score = 0
        ");
        $stmt->execute([
            $session_token,
            $session['learner_id'],
            $session['assessment_id']
        ]);
    }

    echo json_encode([
        'success' => true,
        'message' => 'Exam terminated successfully',
        'reason' => $reason
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error', 'details' => $e->getMessage()]);
}
?>
