<?php
/**
 * Record Violation API
 * Logs security violations for monitoring
 */

require_once '../config/database.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die(json_encode(['error' => 'Method not allowed']));
}

$data = json_decode(file_get_contents('php://input'), true);

$session_token = $data['session_token'] ?? '';
$violation_type = $data['violation_type'] ?? 'unknown';
$description = $data['description'] ?? '';

if (empty($session_token)) {
    http_response_code(400);
    die(json_encode(['error' => 'Session token required']));
}

try {
    // Insert violation record using existing table structure
    $stmt = $pdo->prepare("
        INSERT INTO security_violations (
            session_token, violation_type, violation_severity, 
            violation_details, detected_at, action_taken
        ) VALUES (?, ?, 'high', ?, NOW(), 'logged')
    ");
    $stmt->execute([$session_token, $violation_type, $description]);

    // Update violation count in active_sessions if column exists
    try {
        $stmt = $pdo->prepare("
            UPDATE active_sessions 
            SET violation_count = COALESCE(violation_count, 0) + 1
            WHERE session_token = ?
        ");
        $stmt->execute([$session_token]);
    } catch (Exception $e) {
        // Column might not exist, ignore
    }

    echo json_encode([
        'success' => true,
        'message' => 'Violation recorded',
        'violation_id' => $pdo->lastInsertId()
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error', 'details' => $e->getMessage()]);
}
?>
