<?php
require_once 'api/tmdb.php';

$pageTitle = 'Search - AniCineHub';
$pageDescription = 'Search for your favorite anime, movies, and TV shows.';

$searchQuery = $_GET['q'] ?? '';
$searchResults = null;

if (!empty($searchQuery)) {
    $searchResults = searchMedia($searchQuery);
}

include 'includes/header.php';
?>



<!-- Search Hero -->
<section class="search-hero">
    <div class="container">
        <h1 style="font-size: 3rem; margin-bottom: 1rem;">
            <i class="fas fa-search" style="color: var(--neon-blue);"></i> 
            Search AniCineHub
        </h1>
        <p style="font-size: 1.2rem; color: var(--text-gray);">
            Discover anime, movies, and TV shows from around the world
        </p>
        
        <div class="search-box">
            <form method="GET" action="search.php">
                <input 
                    type="text" 
                    name="q" 
                    id="searchInput" 
                    placeholder="Enter title, actor, or keyword..."
                    value="<?= htmlspecialchars($searchQuery) ?>"
                    autocomplete="off"
                    autofocus>
                <button type="submit">
                    <i class="fas fa-search"></i>
                </button>
            </form>
        </div>
    </div>
</section>

<!-- Search Results -->
<section class="section">
    <div class="container">
        <?php if (!empty($searchQuery)): ?>
            <div class="section-header">
                <h2 class="section-title">
                    Results for "<?= htmlspecialchars($searchQuery) ?>"
                </h2>
                <?php if (!empty($searchResults['results'])): ?>
                    <span style="color: var(--text-gray);">
                        Found <?= number_format($searchResults['total_results'] ?? 0) ?> results
                    </span>
                <?php endif; ?>
            </div>
            
            <?php if (!empty($searchResults['results'])): ?>
                <div id="searchResults" class="grid grid-5">
                    <?php foreach ($searchResults['results'] as $item): 
                        $title = $item['title'] ?? $item['name'] ?? 'Untitled';
                        $year = $item['release_date'] ?? $item['first_air_date'] ?? '';
                        $type = $item['media_type'] ?? 'movie';
                        ?>
                        <div class="card card-entrance">
                            <a href="details.php?id=<?= $item['id'] ?>&type=<?= $type ?>">
                                <img src="<?= getImageUrl($item['poster_path'] ?? null) ?>" 
                                     alt="<?= htmlspecialchars($title) ?>" 
                                     class="card-image"
                                     loading="lazy">
                            </a>
                            <div class="card-content">
                                <h3 class="card-title"><?= htmlspecialchars($title) ?></h3>
                                <div class="card-meta">
                                    <span class="rating">
                                        <i class="fas fa-star"></i> 
                                        <?= formatRating($item['vote_average'] ?? 0) ?>
                                    </span>
                                    <?php if (!empty($year)): ?>
                                        <span><?= getYear($year) ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-search"></i>
                    <h3>No Results Found</h3>
                    <p>We couldn't find anything matching "<?= htmlspecialchars($searchQuery) ?>"</p>
                    <p style="font-size: 0.95rem; margin-top: 1rem;">Try different keywords or check your spelling</p>
                </div>
            <?php endif; ?>
            
        <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-film"></i>
                <h3>Start Your Search</h3>
                <p>Enter a title, actor, or keyword to discover content</p>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
