<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo $pageDescription ?? 'Track your favorite anime, movies and TV shows. Discover trending content, get recommendations, and build your watchlist.'; ?>">
    <meta name="keywords" content="anime tracker, movie tracker, tv shows, TMDB, anime list, movie list">
    <meta name="author" content="AniCineHub">
    
    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo $pageTitle ?? 'AniCineHub - Anime, Movies & TV Tracker'; ?>">
    <meta property="og:description" content="<?php echo $pageDescription ?? 'Track your favorite anime, movies and TV shows'; ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo SITE_URL . $_SERVER['REQUEST_URI']; ?>">
    <meta property="og:image" content="<?php echo SITE_URL; ?>/assets/images/og-image.jpg">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $pageTitle ?? 'AniCineHub'; ?>">
    <meta name="twitter:description" content="<?php echo $pageDescription ?? 'Track anime, movies and TV shows'; ?>">
    
    <title><?php echo $pageTitle ?? 'AniCineHub - Anime, Movies & TV Tracker'; ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo SITE_URL; ?>/assets/images/favicon.png">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/assets/css/style.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/assets/css/animations.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/assets/css/responsive.css?v=<?php echo time(); ?>">
</head>
<body class="<?php echo isset($_COOKIE['night_mode']) && $_COOKIE['night_mode'] === 'true' ? 'night-mode' : ''; ?>">
    
    <!-- Loading Screen -->
    <div class="loading-screen" id="loadingScreen">
        <div class="loading-content">
            <div class="loader"></div>
            <p>Loading AniCineHub...</p>
        </div>
    </div>
    
    <!-- Navigation -->
    <nav class="navbar" id="navbar">
        <div class="container">
            <div class="nav-wrapper">
                <!-- Logo -->
                <a href="index.php" class="logo">
                    <i class="fas fa-film"></i>
                    <span class="logo-text">Ani<span class="highlight">Cine</span>Hub</span>
                </a>
                
                <!-- Desktop Menu -->
                <ul class="nav-menu" id="navMenu">
                    <li><a href="index.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                        <i class="fas fa-home"></i> Home
                    </a></li>
                    <li><a href="search.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'search.php' ? 'active' : ''; ?>">
                        <i class="fas fa-search"></i> Search
                    </a></li>
                    <li><a href="trending.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'trending.php' ? 'active' : ''; ?>">
                        <i class="fas fa-fire"></i> Trending
                    </a></li>
                    <li><a href="favorites.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'favorites.php' ? 'active' : ''; ?>">
                        <i class="fas fa-heart"></i> Favorites
                        <?php if (isset($_SESSION['favorites']) && count($_SESSION['favorites']) > 0): ?>
                            <span class="badge"><?php echo count($_SESSION['favorites']); ?></span>
                        <?php endif; ?>
                    </a></li>
                </ul>
                
                <!-- Right Side -->
                <div class="nav-right">
                    <!-- Search Icon -->
                    <button class="icon-btn search-toggle" id="searchToggle">
                        <i class="fas fa-search"></i>
                    </button>
                    
                    <!-- Night Mode Toggle -->
                    <button class="icon-btn night-mode-toggle" id="nightModeToggle">
                        <i class="fas fa-moon"></i>
                    </button>
                    
                    <!-- Mobile Menu Toggle -->
                    <button class="hamburger" id="hamburger">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Search Bar Dropdown -->
        <div class="search-dropdown" id="searchDropdown">
            <div class="container">
                <div class="search-wrapper">
                    <i class="fas fa-search"></i>
                    <input type="text" id="navSearchInput" placeholder="Search anime, movies, TV shows..." autocomplete="off">
                    <button class="close-search" id="closeSearch">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="search-suggestions" id="navSearchSuggestions"></div>
            </div>
        </div>
    </nav>
    
    <!-- Mobile Menu Overlay -->
    <div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>
