# AniCineHub 🎬🍿

**Modern 2025-style responsive website for tracking anime, movies, and TV shows**

Built with **HTML, CSS, JavaScript, and PHP** integrated with **TMDB API**.

## 🌟 Features

### Core Functionality
- ✅ **Real-time Search** with autocomplete suggestions
- ✅ **Trending Content** - Anime, Movies, and TV Shows
- ✅ **Detailed Information** - Cast, trailers, recommendations
- ✅ **Favorites System** - Save and track your favorite content
- ✅ **Responsive Design** - Optimized for all devices

### Modern UI/UX
- 🎨 **Glassmorphism** cards with frosted backgrounds
- 🌈 **Neon Color Scheme** - Electric Blue & Purple gradients
- ✨ **Smooth Animations** - Fade, slide, glow effects
- 🎭 **Particles Background** - Animated hero section
- 🎠 **Carousel Slider** - Auto-playing content showcases
- 🌙 **Night Mode Toggle** - User preference saved
- 📱 **Mobile Responsive** - Touch-optimized interface

### Performance & SEO
- ⚡ **Lazy Loading** - Optimized image loading
- 🔍 **SEO Optimized** - Meta tags, OpenGraph, JSON-LD
- 🗜️ **GZIP Compression** - Faster page loads
- 🎯 **Browser Caching** - Improved repeat visits
- 🔒 **Security Headers** - XSS protection, CSP

## 📂 Project Structure

```
anicinehub/
├── index.php             # Homepage with trending sections
├── search.php            # Search page with autocomplete
├── details.php           # Media details with cast & trailers
├── trending.php          # Trending content with filters
├── favorites.php         # User's saved favorites
├── 404.php              # Custom error page
├── api/
│   ├── tmdb.php         # TMDB API integration layer
│   ├── search.php       # Search endpoint
│   └── favorites.php    # Favorites management API
├── includes/
│   ├── config.php       # Configuration & constants
│   ├── header.php       # Reusable header component
│   └── footer.php       # Reusable footer component
├── assets/
│   ├── css/
│   │   ├── style.css         # Main styles
│   │   ├── animations.css    # Keyframe animations
│   │   └── responsive.css    # Media queries
│   ├── js/
│   │   ├── main.js          # Core functionality
│   │   ├── search.js        # Search & autocomplete
│   │   ├── favorites.js     # Favorites management
│   │   └── animations.js    # UI animations
│   └── images/
│       ├── logo.png
│       ├── hero-bg.jpg
│       └── placeholder.jpg
└── .htaccess            # Apache configuration
```

## 🚀 Installation

### Prerequisites
- PHP 7.4 or higher
- Apache/Nginx web server
- CURL extension enabled

### Setup Steps

1. **Clone/Download** the project files to your server
   ```bash
   git clone [your-repo-url] anicinehub
   cd anicinehub
   ```

2. **Configure Apache** - Ensure mod_rewrite is enabled
   ```bash
   sudo a2enmod rewrite
   sudo systemctl restart apache2
   ```

3. **Set Permissions** (if on Linux)
   ```bash
   chmod -R 755 .
   ```

4. **Access the Website**
   - Open your browser and navigate to your domain
   - For local: `http://localhost/anicinehub`
   - For production: `https://bilalcode.site`

## 🔑 TMDB API Configuration

The website uses TMDB (The Movie Database) API for content.

**API Credentials** (already configured in `includes/config.php`):
- API Key: `1f731e118751ca1b966dc4dd8f59053f`
- Read Access Token: Configured in code

No additional setup required - the API is ready to use!

## 💾 Favorites System

Currently uses **PHP Sessions** for favorites storage.

### To Upgrade to MySQL:

1. Create database table:
```sql
CREATE TABLE favorites (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id VARCHAR(255),
    media_id INT NOT NULL,
    media_type VARCHAR(20),
    title VARCHAR(255),
    poster_path VARCHAR(255),
    rating DECIMAL(3,1),
    added_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
```

2. Update `includes/config.php` with database connection
3. Modify `api/favorites.php` to use database queries

## 🎨 Color Palette

```css
--neon-blue: #00D4FF
--electric-purple: #A259FF
--jet-black: #0A0A0A
--soft-gray: #1E1E1E
```

## 📱 Browser Support

- ✅ Chrome 90+
- ✅ Firefox 88+
- ✅ Safari 14+
- ✅ Edge 90+
- ✅ Mobile browsers (iOS Safari, Chrome Mobile)

## 🔧 Customization

### Change Colors
Edit CSS variables in `assets/css/style.css`:
```css
:root {
    --neon-blue: #YOUR_COLOR;
    --electric-purple: #YOUR_COLOR;
}
```

### Modify API Endpoints
Update functions in `api/tmdb.php`

### Add New Sections
Follow the pattern in `index.php` for new content sections

## 📄 Pages Overview

### 🏠 Homepage (`index.php`)
- Animated hero section with particles
- Trending Anime carousel
- Trending Movies grid
- Trending TV Shows grid
- Popular Today section
- Top Rated section

### 🔍 Search (`search.php`)
- Prominent search bar
- Autocomplete suggestions
- Real-time results
- Multi-type search (Movies, TV, Anime)

### 📺 Details (`details.php`)
- Large backdrop banner
- Full media information
- Play trailer button
- Cast carousel
- Recommendations
- Add to Favorites
- JSON-LD structured data

### 🔥 Trending (`trending.php`)
- Filter by type (Anime/Movies/TV)
- Filter by popularity (Trending/Popular/Top Rated)
- Time filters (Today/This Week)

### ❤️ Favorites (`favorites.php`)
- User's saved items
- Remove functionality
- Empty state with navigation

## 🛠️ Technologies Used

- **Frontend**: HTML5, CSS3, JavaScript (ES6+)
- **Backend**: PHP 7.4+
- **API**: TMDB REST API
- **Libraries**: 
  - Particles.js (hero animations)
  - Font Awesome (icons)
  - Google Fonts (Inter typography)

## 📝 License

This project is for educational and personal use.

**TMDB Attribution**: This product uses the TMDB API but is not endorsed or certified by TMDB.

## 🤝 Support

For issues or questions:
- Check TMDB API status: https://www.themoviedb.org/
- Verify Apache configuration
- Ensure PHP CURL extension is enabled

## 🎯 Roadmap

Future enhancements:
- [ ] User authentication system
- [ ] MySQL database integration
- [ ] User reviews and ratings
- [ ] Watchlist with progress tracking
- [ ] Email notifications
- [ ] Social sharing features
- [ ] Multi-language support

---

**Made with ❤️ using modern web technologies**

🌐 **Live Demo**: [bilalcode.site](https://bilalcode.site)
