<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\FriendController;
use App\Http\Controllers\UserController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/test', function () {
    return response()->json(['message' => 'API is working!']);
});

// Public routes
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    // Auth routes
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);
    
    // User routes
    Route::get('/users', [UserController::class, 'index']);
    Route::get('/users/{id}', [UserController::class, 'show']);
    
    // Friend routes
    Route::prefix('friends')->group(function () {
        Route::post('/send-request/{receiverId}', [FriendController::class, 'sendRequest']);
        Route::post('/accept-request/{requestId}', [FriendController::class, 'acceptRequest']);
        Route::post('/reject-request/{requestId}', [FriendController::class, 'rejectRequest']);
        Route::delete('/cancel-request/{requestId}', [FriendController::class, 'cancelRequest']);
        Route::get('/list', [FriendController::class, 'getFriends']);
        Route::get('/pending', [FriendController::class, 'getPendingRequests']);
        Route::get('/sent', [FriendController::class, 'getSentRequests']);
        Route::delete('/remove/{friendId}', [FriendController::class, 'removeFriend']);
    });
});