<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}
$name = isset($_SESSION['user_name']) ? $_SESSION['user_name'] : '';
$email = isset($_SESSION['user_email']) ? $_SESSION['user_email'] : '';
$profile = isset($_SESSION['user_profile']) ? $_SESSION['user_profile'] : '';
$profile_path = $profile ? 'uploads/' . $profile : '';

// optional: provide logout link handler
?>
<!DOCTYPE html>
<html lang="hi">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Home</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="style.css">
</head>
<body>
  <div class="container">
    <h1 class="page-title">Welcome</h1>

    <div class="table-wrap" style="display:flex;justify-content:center;">
      <div class="profile-card" style="width:420px;max-width:90%;">
        <div style="display:flex;gap:18px;align-items:center;">
          <div style="flex:0 0 120px;">
            <img src="<?php echo htmlspecialchars($profile_path); ?>" alt="Profile" style="width:120px;height:120px;border-radius:12px;object-fit:cover;border:4px solid #c7d2fe;">
          </div>
          <div style="flex:1;text-align:left;">
            <h2 style="margin:0 0 6px 0;color:#1d4ed8;"><?php echo htmlspecialchars($name); ?></h2>
            <p style="margin:0;color:#374151;"><?php echo htmlspecialchars($email); ?></p>
          </div>
        </div>

        <div style="margin-top:18px;text-align:right;">
          <a class="btn" href="logout.php">Logout</a>
        </div>
      </div>
    </div>

  </div>
</body>
</html>
