<?php
// login.php
require 'db_connect.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success" => false, "message" => "Only POST allowed"]);
    exit;
}

$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';

if ($email === '' || $password === '') {
    echo json_encode(["success" => false, "message" => "Email and password required."]);
    exit;
}

$email_e = mysqli_real_escape_string($conn, $email);
$sql = "SELECT id, name, email, password, contact FROM bilal_users_9f3a WHERE email = '$email_e' LIMIT 1";
$res = mysqli_query($conn, $sql);

if ($res && mysqli_num_rows($res) === 1) {
    $row = mysqli_fetch_assoc($res);
    if (password_verify($password, $row['password'])) {
        // return user data (no password)
        $user = [
            "id" => $row['id'],
            "name" => $row['name'],
            "email" => $row['email'],
            "contact" => $row['contact']
        ];
        echo json_encode(["success" => true, "message" => "Login successful.", "user" => $user]);
        exit;
    } else {
        echo json_encode(["success" => false, "message" => "Invalid credentials."]);
        exit;
    }
} else {
    echo json_encode(["success" => false, "message" => "User not found."]);
    exit;
}
?>
