<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - BGNU Exam System</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #0D1117 0%, #161B22 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-box {
            background: #fff;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
            width: 100%;
            max-width: 400px;
        }
        h2 { color: #333; margin-bottom: 30px; text-align: center; }
        .form-group { margin-bottom: 20px; }
        label { display: block; color: #666; margin-bottom: 8px; font-weight: 500; }
        input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e1e4e8;
            border-radius: 8px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        input:focus { outline: none; border-color: #00FFA3; }
        .btn-login {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #00FFA3, #4CC9F0);
            border: none;
            color: #0D1117;
            font-weight: bold;
            font-size: 16px;
            border-radius: 8px;
            cursor: pointer;
            transition: transform 0.2s;
        }
        .btn-login:hover { transform: scale(1.02); }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>🎓 Instructor Login</h2>
        <form method="POST" action="dashboard.php">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" value="admin" required>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" value="admin123" required>
            </div>
            <button type="submit" class="btn-login">Access Dashboard →</button>
        </form>
        <p style="text-align: center; margin-top: 20px; color: #999; font-size: 12px;">
            Default credentials: admin / admin123
        </p>
    </div>
</body>
</html>
