# DINO Exam Browser - Backend Setup Guide

## 📦 Installation Instructions

### Step 1: Upload to Namecheap Hosting
1. Extract `exammode.zip`
2. Upload the extracted `exammode` folder to your Namecheap hosting via FTP or File Manager
3. Place it in the `public_html` directory

### Step 2: Import Database
1. Log in to your Namecheap cPanel
2. Go to **phpMyAdmin**
3. Select your database: `ahmeuesz_dino`
4. Click **Import** tab
5. Choose `sql/schema.sql` file
6. Click **Go** to import

### Step 3: Test the System
1. Visit: `https://bilalcode.site/exammode/`
2. Click **Instructor Dashboard**
3. Login with default credentials:
   - Username: `admin`
   - Password: `admin123`

## 🗄️ Database Details
- **Host**: localhost
- **Database**: ahmeuesz_dino
- **User**: ahmeuesz_dino_user
- **Password**: doraemonnobita

## 📁 File Structure
```
exammode/
├── index.php                # Landing page
├── exam/                    # Student exam interface (coming soon)
├── admin/
│   ├── index.php           # Dashboard login
│   └── dashboard.php       # Live monitoring
├── api/
│   ├── auth.php            # Authentication
│   ├── start-exam.php      # Initialize exam
│   ├── update-progress.php # Progress tracking (INSTANT TERMINATION ON ALT+TAB)
│   ├── submit-answer.php   # Save answer
│   ├── submit-exam.php     # Submit exam
│   ├── get-live-sessions.php # Live dashboard data
│   └── verify-browser.php  # Browser verification
├── config/
│   └── database.php        # Database connection
└── sql/
    └── schema.sql          # Database schema
```

## 🔒 Key Security Features
- ✅ **Instant Termination**: Alt+Tab or window blur immediately terminates exam
- ✅ **Browser-Only Access**: Only DINO Browser can access exams
- ✅ **Real-time Monitoring**: 3-second polling for live dashboard updates
- ✅ **Violation Logging**: All cheating attempts logged to database

## 📊 Modern Database Tables
- `learners` - Students and instructors
- `assessments` - Exam definitions
- `question_bank` - Questions
- `active_sessions` - Real-time exam tracking
- `learner_responses` - Student answers
- `security_violations` - Cheating logs
- `assessment_results` - Final grades

## 🚀 Next Steps
1. Import database schema
2. Create test students via phpMyAdmin
3. Build desktop DINO Browser client
4. Test with live exam

## 📞 Support
For issues, contact: admin@bilalcode.site
