<?php
/**
 * Dino Browser - Database Configuration
 * 
 * This file contains database connection settings.
 * IMPORTANT: In production, move to environment variables.
 */

define('DB_HOST', 'localhost');
define('DB_NAME', 'ahmeuesz_dino_brwos');
define('DB_USER', 'ahmeuesz_dino_user');
define('DB_PASS', 'doraemonnobita');
define('DB_CHARSET', 'utf8mb4');

/**
 * Get database connection
 * @return PDO
 */
function getConnection() {
    static $pdo = null;
    
    if ($pdo === null) {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
        ];
        
        try {
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            http_response_code(500);
            die(json_encode([
                'success' => false,
                'error' => 'Database connection failed'
            ]));
        }
    }
    
    return $pdo;
}

/**
 * Send JSON response
 * @param array $data
 * @param int $statusCode
 */
function jsonResponse($data, $statusCode = 200) {
    http_response_code($statusCode);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}

/**
 * Get request input
 * @return array
 */
function getInput() {
    $contentType = $_SERVER['CONTENT_TYPE'] ?? '';
    
    if (strpos($contentType, 'application/json') !== false) {
        $input = json_decode(file_get_contents('php://input'), true);
        return $input ?? [];
    }
    
    return array_merge($_GET, $_POST);
}

/**
 * Validate required fields
 * @param array $input
 * @param array $required
 * @return bool
 */
function validateRequired($input, $required) {
    foreach ($required as $field) {
        if (!isset($input[$field]) || $input[$field] === '') {
            return false;
        }
    }
    return true;
}

/**
 * Sanitize string input
 * @param string $input
 * @return string
 */
function sanitize($input) {
    return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
}

/**
 * Log sync operation
 * @param PDO $pdo
 * @param string $userId
 * @param string $syncType
 * @param int $itemsCount
 * @param string $direction
 * @param string $status
 * @param string|null $error
 */
function logSync($pdo, $userId, $syncType, $itemsCount, $direction, $status, $error = null) {
    try {
        $stmt = $pdo->prepare("
            INSERT INTO sync_log (user_id, sync_type, items_synced, direction, status, error_message)
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([$userId, $syncType, $itemsCount, $direction, $status, $error]);
    } catch (PDOException $e) {
        // Silent fail for logging
    }
}

// Set CORS headers for API access
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
