<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Tutorial Video</title>
  <style>
      /* ===== Modern 2025 YouTube Page ===== */
body {
  margin: 0;
  font-family: 'Poppins', sans-serif;
  background: linear-gradient(135deg, #a1c4fd, #c2e9fb);
  min-height: 100vh;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
}

.youtube-wrapper {
  text-align: center;
  background: #ffffffcc;
  backdrop-filter: blur(8px);
  border-radius: 20px;
  padding: 40px;
  width: 90%;
  max-width: 600px;
  box-shadow: 0 8px 30px rgba(0, 0, 0, 0.15);
  animation: fadeUp 0.8s ease;
}

h2 {
  margin-bottom: 20px;
  color: #333;
  font-size: 26px;
  letter-spacing: 1px;
}

.video-container {
  position: relative;
  width: 100%;
  aspect-ratio: 1 / 1; /* makes it a perfect square */
  overflow: hidden;
  border-radius: 20px;
  box-shadow: 0 0 25px rgba(108, 99, 255, 0.4);
  transition: all 0.4s;
}

.video-container:hover {
  transform: scale(1.05);
}

iframe {
  width: 100%;
  height: 100%;
  border: none;
  border-radius: 20px;
}

/* Fade Animation */
@keyframes fadeUp {
  from {
    opacity: 0;
    transform: translateY(15px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}

  </style>
</head>
<body>

  <div class="youtube-wrapper">
    <h2>Watch Our Tutorial</h2>
    <div class="video-container">
      <iframe 
        src="https://www.youtube.com/embed/A_fTvqQ7SEA" 
        title="Tutorial Video"
        frameborder="0"
        allowfullscreen>
      </iframe>
    </div>
  </div>

</body>
</html>
