<?php
require_once 'api/tmdb.php';

$pageTitle = 'AniCineHub - Track Anime, Movies & TV Shows';
$pageDescription = 'Discover and track trending anime, movies, and TV shows. Get recommendations and never miss your favorite content.';

// Fetch trending data
$trendingAnime = getTrendingAnime();
$trendingMovies = getTrendingMovies();
$trendingTV = getTrendingTV();
$popularMovies = getPopular('movie');
$topRatedMovies = getTopRated('movie');

include 'includes/header.php';
?>

<!-- Hero Section -->
<section class="hero">
    <div id="particles-js" style="position: absolute; width: 100%; height: 100%; top: 0; left: 0;"></div>
    <div class="hero-overlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: linear-gradient(180deg, rgba(10,10,10,0.7) 0%, rgba(10,10,10,0.9) 100%);"></div>
    <div class="container" style="position: relative; z-index: 2; padding: 80px 0 80px;">
        <div class="hero-content" style="text-align: center; max-width: 900px; margin: 0 auto;">
            <h1 class="hero-title" style="font-size: 4rem; margin-bottom: 1.5rem; background: linear-gradient(135deg, #00D4FF 0%, #A259FF 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">
                Track Your Favorite <br>Anime, Movies & TV Shows
            </h1>
            <p class="hero-subtitle" style="font-size: 1.3rem; color: #B0B0B0; margin-bottom: 2rem;">
                Discover trending content, get personalized recommendations, and build your ultimate watchlist
            </p>
            <div class="hero-buttons" style="display: flex; gap: 1rem; justify-content: center; flex-wrap: wrap;">
                <a href="search.php" class="btn btn-primary">
                    <i class="fas fa-search"></i> Start Exploring
                </a>
                <a href="trending.php" class="btn btn-secondary">
                    <i class="fas fa-fire"></i> View Trending
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Trending Anime Section -->
<section class="section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title"><i class="fas fa-fire"></i> Trending Anime</h2>
            <a href="trending.php?type=anime" class="btn btn-secondary">View All</a>
        </div>
        
        <?php if (!empty($trendingAnime['results'])): ?>
            <div class="carousel" data-items-per-view="6" data-autoplay="true" data-autoplay-delay="5000">
                <div class="carousel-container">
                    <div class="carousel-track">
                        <?php foreach (array_slice($trendingAnime['results'], 0, 30) as $anime): ?>
                            <div class="carousel-item">
                                <div class="card card-entrance">
                                    <a href="details.php?id=<?= $anime['id'] ?>&type=tv">
                                        <img src="<?= getImageUrl($anime['poster_path']) ?>" 
                                             alt="<?= htmlspecialchars($anime['name'] ?? 'Untitled') ?>" 
                                             class="card-image"
                                             loading="lazy">
                                    </a>
                                    <div class="card-content">
                                        <h3 class="card-title"><?= htmlspecialchars($anime['name'] ?? 'Untitled') ?></h3>
                                        <div class="card-meta">
                                            <span class="rating">
                                                <i class="fas fa-star"></i> 
                                                <?= formatRating($anime['vote_average'] ?? 0) ?>
                                            </span>
                                            <?php if (!empty($anime['first_air_date'])): ?>
                                                <span><?= getYear($anime['first_air_date']) ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <button class="carousel-prev" aria-label="Previous">
                    <i class="fas fa-chevron-left"></i>
                </button>
                <button class="carousel-next" aria-label="Next">
                    <i class="fas fa-chevron-right"></i>
                </button>
                <div class="carousel-dots"></div>
            </div>
        <?php else: ?>
            <p class="text-center text-gray">No trending anime available</p>
        <?php endif; ?>
    </div>
</section>

<!-- Trending Movies Section -->
<section class="section" style="background: rgba(30,30,30,0.3);">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title"><i class="fas fa-film"></i> Trending Movies</h2>
            <a href="trending.php?type=movie" class="btn btn-secondary">View All</a>
        </div>
        
        <?php if (!empty($trendingMovies['results'])): ?>
            <div class="grid grid-6">
                <?php foreach (array_slice($trendingMovies['results'], 0, 12) as $movie): ?>
                    <div class="card card-entrance">
                        <a href="details.php?id=<?= $movie['id'] ?>&type=movie">
                            <img src="<?= getImageUrl($movie['poster_path']) ?>" 
                                 alt="<?= htmlspecialchars($movie['title'] ?? 'Untitled') ?>" 
                                 class="card-image"
                                 loading="lazy">
                        </a>
                        <div class="card-content">
                            <h3 class="card-title"><?= htmlspecialchars($movie['title'] ?? 'Untitled') ?></h3>
                            <div class="card-meta">
                                <span class="rating">
                                    <i class="fas fa-star"></i> 
                                    <?= formatRating($movie['vote_average'] ?? 0) ?>
                                </span>
                                <?php if (!empty($movie['release_date'])): ?>
                                    <span><?= getYear($movie['release_date']) ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p class="text-center text-gray">No trending movies available</p>
        <?php endif; ?>
    </div>
</section>

<!-- Trending TV Shows Section -->
<section class="section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title"><i class="fas fa-tv"></i> Trending TV Shows</h2>
            <a href="trending.php?type=tv" class="btn btn-secondary">View All</a>
        </div>
        
        <?php if (!empty($trendingTV['results'])): ?>
            <div class="grid grid-6">
                <?php foreach (array_slice($trendingTV['results'], 0, 12) as $show): ?>
                    <div class="card card-entrance">
                        <a href="details.php?id=<?= $show['id'] ?>&type=tv">
                            <img src="<?= getImageUrl($show['poster_path']) ?>" 
                                 alt="<?= htmlspecialchars($show['name'] ?? 'Untitled') ?>" 
                                 class="card-image"
                                 loading="lazy">
                        </a>
                        <div class="card-content">
                            <h3 class="card-title"><?= htmlspecialchars($show['name'] ?? 'Untitled') ?></h3>
                            <div class="card-meta">
                                <span class="rating">
                                    <i class="fas fa-star"></i> 
                                    <?= formatRating($show['vote_average'] ?? 0) ?>
                                </span>
                                <?php if (!empty($show['first_air_date'])): ?>
                                    <span><?= getYear($show['first_air_date']) ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p class="text-center text-gray">No trending TV shows available</p>
        <?php endif; ?>
    </div>
</section>

<!-- Popular Today Section -->
<section class="section" style="background: rgba(30,30,30,0.3);">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title"><i class="fas fa-star"></i> Popular Today</h2>
            <a href="trending.php?filter=popular" class="btn btn-secondary">View All</a>
        </div>
        
        <?php if (!empty($popularMovies['results'])): ?>
            <div class="grid grid-5">
                <?php foreach (array_slice($popularMovies['results'], 0, 10) as $movie): ?>
                    <div class="card card-entrance">
                        <a href="details.php?id=<?= $movie['id'] ?>&type=movie">
                            <img src="<?= getImageUrl($movie['poster_path']) ?>" 
                                 alt="<?= htmlspecialchars($movie['title'] ?? 'Untitled') ?>" 
                                 class="card-image"
                                 loading="lazy">
                        </a>
                        <div class="card-content">
                            <h3 class="card-title"><?= htmlspecialchars($movie['title'] ?? 'Untitled') ?></h3>
                            <div class="card-meta">
                                <span class="rating">
                                    <i class="fas fa-star"></i> 
                                    <?= formatRating($movie['vote_average'] ?? 0) ?>
                                </span>
                                <?php if (!empty($movie['release_date'])): ?>
                                    <span><?= getYear($movie['release_date']) ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p class="text-center text-gray">No popular content available</p>
        <?php endif; ?>
    </div>
</section>

<!-- Top Rated Section -->
<section class="section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title"><i class="fas fa-trophy"></i> Top Rated</h2>
            <a href="trending.php?filter=top" class="btn btn-secondary">View All</a>
        </div>
        
        <?php if (!empty($topRatedMovies['results'])): ?>
            <div class="grid grid-5">
                <?php foreach (array_slice($topRatedMovies['results'], 0, 10) as $movie): ?>
                    <div class="card card-entrance">
                        <a href="details.php?id=<?= $movie['id'] ?>&type=movie">
                            <img src="<?= getImageUrl($movie['poster_path']) ?>" 
                                 alt="<?= htmlspecialchars($movie['title'] ?? 'Untitled') ?>" 
                                 class="card-image"
                                 loading="lazy">
                        </a>
                        <div class="card-content">
                            <h3 class="card-title"><?= htmlspecialchars($movie['title'] ?? 'Untitled') ?></h3>
                            <div class="card-meta">
                                <span class="rating">
                                    <i class="fas fa-star"></i> 
                                    <?= formatRating($movie['vote_average'] ?? 0) ?>
                                </span>
                                <?php if (!empty($movie['release_date'])): ?>
                                    <span><?= getYear($movie['release_date']) ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p class="text-center text-gray">No top rated content available</p>
        <?php endif; ?>
    </div>
</section>

<style>
.hero {
    position: relative;
    min-height: 600px;
    display: flex;
    align-items: center;
}

.carousel-container {
    position: relative;
    z-index: 1;
}

@media (max-width: 1199px) {
    .carousel-item {
        flex: 0 0 25% !important;
    }
}

@media (max-width: 768px) {
    .hero-title {
        font-size: 2.5rem !important;
    }
    .hero-subtitle {
        font-size: 1.1rem !important;
    }
    .carousel-item {
        flex: 0 0 50% !important;
    }
}
</style>

<?php include 'includes/footer.php'; ?>
