<?php
require_once 'includes/config.php';

$pageTitle = '404 - Page Not Found - AniCineHub';
$pageDescription = 'The page you are looking for could not be found.';

http_response_code(404);

include 'includes/header.php';
?>

<style>
.error-404 {
    min-height: calc(100vh - 200px);
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    padding: 3rem 1rem;
}

.error-content {
    max-width: 600px;
}

.error-code {
    font-size: 10rem;
    font-weight: 900;
    line-height: 1;
    background: var(--gradient-primary);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    margin-bottom: 1rem;
    animation: pulse 2s ease-in-out infinite;
}

.error-illustration {
    font-size: 8rem;
    margin: 2rem 0;
    animation: float 3s ease-in-out infinite;
}

.error-title {
    font-size: 2.5rem;
    margin-bottom: 1rem;
}

.error-description {
    font-size: 1.2rem;
    color: var(--text-gray);
    margin-bottom: 2rem;
}

.error-search {
    max-width: 500px;
    margin: 2rem auto;
}

.error-search input {
    width: 100%;
    padding: 1rem 1.5rem;
    background: rgba(30,30,30,0.8);
    border: 2px solid rgba(255,255,255,0.1);
    border-radius: 50px;
    color: white;
    font-size: 1rem;
}

.error-search input:focus {
    outline: none;
    border-color: var(--neon-blue);
    box-shadow: 0 0 20px rgba(0,212,255,0.3);
}

.error-links {
    display: flex;
    gap: 1rem;
    justify-content: center;
    flex-wrap: wrap;
    margin-top: 2rem;
}
</style>

<section class="error-404">
    <div class="error-content">
        <div class="error-code">404</div>
        
        <div class="error-illustration">
            <i class="fas fa-ghost"></i>
        </div>
        
        <h1 class="error-title">Oops! Page Not Found</h1>
        
        <p class="error-description">
            Looks like this page took a trip to another dimension. 
            Don't worry, we can help you get back on track!
        </p>
        
        <div class="error-search">
            <form action="search.php" method="GET">
                <input 
                    type="text" 
                    name="q" 
                    placeholder="Search for anime, movies, TV shows..." 
                    autocomplete="off">
            </form>
        </div>
        
        <div class="error-links">
            <a href="index.php" class="btn btn-primary">
                <i class="fas fa-home"></i> Back to Home
            </a>
            <a href="trending.php" class="btn btn-secondary">
                <i class="fas fa-fire"></i> View Trending
            </a>
            <a href="search.php" class="btn btn-secondary">
                <i class="fas fa-search"></i> Advanced Search
            </a>
        </div>
        
        <p style="margin-top: 3rem; color: var(--text-gray); font-size: 0.95rem;">
            If you believe this is an error, please 
            <a href="#" style="color: var(--neon-blue); text-decoration: underline;">contact support</a>
        </p>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
